<?php
// Inisialisasi variabel untuk pesan feedback
$message = '';

// 1. LOGIKA PEMROSESAN UPLOAD FILE
// Cek apakah request adalah POST, yang artinya formulir telah disubmit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Tentukan direktori tujuan
    $uploadDir = 'uploads/';

    // Buat direktori jika belum ada
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    // Cek apakah file 'berkas' telah di-set dan tidak ada error
    if (isset($_FILES['berkas']) && $_FILES['berkas']['error'] === 0) {
        $fileName = basename($_FILES['berkas']['name']);
        $targetFile = $uploadDir . $fileName;

        // Validasi
        $uploadOk = true;
        $errors = [];

        // Cek jika file sudah ada
        if (file_exists($targetFile)) {
            $errors[] = "Maaf, file dengan nama yang sama sudah ada.";
            $uploadOk = false;
        }

        // Cek ukuran file (misal: max 5MB)
        if ($_FILES['berkas']['size'] > 5000000) {
            $errors[] = "Maaf, ukuran file terlalu besar (Maksimal 5MB).";
            $uploadOk = false;
        }

        // -- BAGIAN VALIDASI TIPE FILE TELAH DIHAPUS SESUAI PERMINTAAN --

        // Jika semua validasi lolos, pindahkan file
        if ($uploadOk) {
            if (move_uploaded_file($_FILES['berkas']['tmp_name'], $targetFile)) {
                $message = "File <strong>" . htmlspecialchars($fileName) . "</strong> berhasil diunggah.";
            } else {
                $message = "Terjadi kesalahan saat mencoba memindahkan file.";
            }
        } else {
            // Gabungkan semua pesan error
            $message = implode("<br>", $errors);
        }
    } else {
        $message = "Pilih file terlebih dahulu atau terjadi error pada file.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mini Uploader PHP (Tanpa Filter)</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; background-color: #f0f2f5; margin: 0; }
        .container { background: #fff; padding: 2rem; border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); text-align: center; width: 90%; max-width: 400px; }
        h2 { margin-top: 0; color: #333; }
        .message { padding: 1rem; margin-bottom: 1rem; border-radius: 5px; color: #fff; }
        .message:not(:empty) { background-color: #e74c3c; <?php if (strpos($message, 'berhasil') !== false) echo 'background-color: #2ecc71;'; ?> }
        input[type="file"] { display: block; width: 100%; padding: 10px; margin-bottom: 1rem; border: 1px solid #ccc; border-radius: 5px; box-sizing: border-box; }
        input[type="submit"] { width: 100%; background-color: #3498db; color: white; border: none; padding: 12px 20px; border-radius: 5px; cursor: pointer; font-size: 16px; font-weight: bold; }
        input[type="submit"]:hover { background-color: #2980b9; }
        .warning { background-color: #f39c12; color: #fff; padding: 10px; border-radius: 5px; margin-top: 1rem; text-align: left; }
    </style>
</head>
<body>

    <div class="container">
        <h2>Mini Uploader (Tanpa Filter)</h2>
        
        <div class="message">
            <?php echo $message; ?>
        </div>
        
        <form action="" method="post" enctype="multipart/form-data">
            <input type="file" name="berkas" required>
            <input type="submit" value="Upload Sekarang">
        </form>

        <div class="warning">
            <strong>Peringatan:</strong> Formulir ini mengizinkan semua jenis file untuk diunggah. Gunakan dengan hati-hati.
        </div>
    </div>

</body>
</html>